function data_bloomberg = import_data_bloomberg()
% --------------------------------------------------------------------------------------------------
% Import historical stock prices and market-cap from Bloomberg
% --------------------------------------------------------------------------------------------------
% sample call: data_bloomberg = import_data_bloomberg()
% --------------------------------------------------------------------------------------------------

% Import data
[num, txt] = xlsread('c:/thesis/data/bloomberg/CDX stock prices2.xls', 1);
[num2, txt2] = xlsread('c:/thesis/data/bloomberg/CDX stock prices2.xls', 2);
[num3, txt3] = xlsread('c:/thesis/data/bloomberg/CDX stock prices2.xls', 3);

% Define relevant columns
market_cap = [num(:,1:4:end) num2(:,1:4:end) num3(:,1:4:end)];
prices = [num(:,2:4:end) num2(:,2:4:end) num3(:,2:4:end)];
dates = [txt(3:end,1:4:end) txt2(3:end,1:4:end) txt3(3:end,1:4:end)];
num_firms = size(prices, 2);
company_names = [txt(1,1:4:end) txt2(1,1:4:end) txt3(1,1:4:end)];

% For each firm, generate nice time series object
for i=1:num_firms
    % Extract company name
    pos = findstr(company_names{i}, ' ');
    if (isempty(pos))
        continue;
    end
    name = company_names{i}(1:(pos-1));
    
    % FD was renamed to M on June 1, 2007
    if (strcmp(name, 'M'))
        name = 'FD';
    end
    
    % Remove missing data
    available = ~strcmp(dates(:,i), '');
    dates_i = datenum(dates(available,i));
    prices_i = prices(available,i);
    mcap_i = market_cap(available,i);
    available = ~(isnan(prices_i) | isnan(mcap_i));
    dates_i = dates_i(available);
    prices_i = prices_i(available);
    mcap_i = mcap_i(available);
    
    % Generate time series object
    data = struct('ticker', name, 'dates', dates_i, 'price', prices_i, 'mcap', mcap_i);
    if (i==1)
        data_bloomberg = data;
    else
        data_bloomberg = [data_bloomberg data];
    end
end
